s         ձ   =  Q  %`                                     SNSGA                           Sorensen SGA                                                                                            ViInt16     ViInt32    ViReal64      ViRsrc     	 	ViBoolean     	 	ViSession      ViStatus       ViChar[]      ViChar      ViString     	  ViInt16[]     	  ViInt32[]     
  	ViReal64[]      	 
ViBoolean[]     
 
ViConstString      This instrument module provides programming support for the Sorensen SGA.  The module is divided into the following functions:

Functions/Classes:

(1) Initialize:
This function initializes the instrument and sets it to a default configuration.

(2) Application Functions: (Class)
This class contains high-level, test and measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

(3) Configuration Functions: (Class)
This class of functions configures the instrument by setting acquisition and system configuration parameters.

(4) Action/Status Functions: (Class)
This class of functions begins or terminates an acquisition. It also provides functions which allow the user to determine the current status of the instrument.

(5) Utility Functions: (Class)
This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

(7) Close:
This function takes the instrument offline.
         This class contains high-level, test and measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

         Output State         This class of functions configures the instrument by setting acquisition and system configuration parameters.

Functions/SubClasses:

() Function Name:
This function ...         This class of functions begins or terminates an acquisition. It also provides functions which allow the user to determine the current status of the instrument.

Functions/SubClasses:

() Function Name:
This function ...    W    This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

Functions:

(1) Write To Instrument:
This function writes commands and queries to the instrument to modify parameters and query device settings.

(2) Read Instrument Data:
This function reads data from instrument buffer and returns it to the specified variable in memory.

(3) Reset:
This function resets the instrument to its default state.

(4) Self-Test:
This function runs the instrument self test and returns the test code.

(5) Error Query:
This function reads an error code from the instrument error queue.

(6) Error Message:
This function takes the Status Code and returns it as a user readable string.
 
(7) Revision Query:
This function returns the revision numbers of the instrument driver and instrument firmware.
        Sorensen SGA Power Supplies with an Remote Programming Interface option.

This function performs the following initialization actions:

- Opens a session to the Default Resource Manager resource and a session to the specified device using the interface and address specified in the Resource_Name control.

- Performs an identification query on the Instrument.

- Resets the instrument to a known state and clears all error and status information.

- Returns an Instrument Handle which is used to differentiate between different sessions of this instrument driver.

- Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
    q    This control specifies the interface and address of the device that is to be initialized (Instrument Descriptor). The exact grammar to be used in this control is shown in the note below. 

Default Value:  "GPIB::1"

Notes:

(1) Based on the Instrument Descriptor, this operation establishes a communication session with a device.  The grammar for the Instrument Descriptor is shown below.  Optional parameters are shown in square brackets ([]).

Interface   Grammar
------------------------------------------------------
GPIB        GPIB[board]::primary address[::secondary address]
            [::INSTR]
            
The GPIB keyword is used with GPIB instruments.

The default value for optional parameters are shown below.

Optional Parameter          Default Value
-----------------------------------------
board                       0
secondary address           none - 31
        This control specifies if an ID Query is sent to the instrument during the initialization procedure.

Valid Range:
VI_OFF (0) - Skip Query
VI_ON  (1) - Do Query (Default Value)

Notes:
   
(1) Under normal circumstances the ID Query ensures that the instrument initialized is the type supported by this driver. However circumstances may arise where it is undesirable to send an ID Query to the instrument.  In those cases; set this control to "Skip Query" and this function will initialize the selected interface, without doing an ID Query.
    D    This control specifies if the instrument is to be reset to its power-on settings during the initialization procedure.

Valid Range:
VI_OFF (0) - Don't Reset
VI_ON  (1) - Reset Device (Default Value)

Notes:

(1) If you do not want the instrument reset. Set this control to "Don't Reset" while initializing the instrument.
    7    This control returns an Instrument Handle that is used in all subsequent function calls to differentiate between different sessions of this instrument driver.

Notes:

(1) Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 

     =         Resource Name                      :        ID Query                          & =        Reset Device                      r     }    Instrument Handle                        Status                             
"GPIB::1"   Yes VI_ON No VI_OFF   Yes VI_ON No VI_OFF    	           	           {    This function configures and initiates the power supply to generate a DC voltage.

SCPI: SOURCE[]:VOLTAGE <voltage value>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     y    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     x    Pass the DC voltage you want the power supply to generate.
Units: volts

Valid Range: dependent upon the model in use
    &          Instrument Handle                         Status                            O 3        Voltage                                	           0.0    {    This function configures and initiates the power supply to generate a DC current.

SCPI: SOURCE[]:CURRENT <current value>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     y    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     {    Pass the DC current you want the power supply to generate.
Units: ampheres

Valid Range: dependent upon the model in use
              Instrument Handle                         Status                            1 3        Current                                	           0.0   D    This function configures and initiates the power supply to generate a DC voltage ramp starting from the present output voltage and ending at the specified voltage in the specified time. Time range is from 100ms to 99sec. with 100ms resolution. Time is in seconds.

SCPI: SOURCE[]:VOLTAGE:RAMP <ending voltage value> <time>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     y    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     w    Pass the DC voltage you want the power supply to generate.
Units: volts
Valid Range: dependent upon the model in use
     -    Ramp time in seconds.
Valid range 0.1 - 99.              Instrument Handle                  ^        Status                              3        Voltage                           !^ 3       Time                                   	           0.0    0.0   D    This function configures and initiates the power supply to generate a DC current ramp starting from the present output current and ending at the specified current in the specified time. Time range is from 100ms to 99sec. with 100ms resolution. Time is in seconds.

SCPI: SOURCE[]:CURRENT:RAMP <ending current value> <time>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      x    Pass the DC current you want the power supply to generate.
Units: amps

Valid Range: dependent upon the model in use

     .    Ramp time in seconds.
Range is 0.1 - 99 sec.    #          Instrument Handle                 $y        Status                            $ =        Current                           %{ @        Time                                   	           0.0    0.0        This function sets the output state to On (1) or Off (0). If set to OFF the Voltage and Current values will be set to zero. If set to ON the Voltage and Current will be set to their last programmed values.         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     'z  4        Instrument Handle                 ("       Status                           aL        State                                  	            On 1 Off 0    T    This function takes a voltage measurement of the output.

SCPI: MEASURE[]:VOLTAGE?     +    Returns the measured value.

Units: volts         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     ) 3        Voltage Measurement               )  	        Instrument Handle                 *        Status                             	               	           T    This function takes a current measurement of the output.

SCPI: MEASURE[]:CURRENT?     /    Returns the measured value.

Units:  amperes
         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     ,1 3        Current Measurement               ,h  	        Instrument Handle                 -        Status                             	               	               This function returns the operationing mode of the power supply. The two modes of operation are constant voltage (mode = 0) and constant current (mode = 1). See Protection Condition Status Register for more information.         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     /2  /        Instrument Handle                 / H      status                           [C       Mode                               0    	            	               The power supply has two modes of operation: constant current and constant voltage. This function configures the power supply to shut down if the power supply switches from constant voltage mode to constant current mode. If Service Request is set ON (1) the Protection Event Status reporting mechanism will be turned on and a GPIB Service Request will be generated upon this action.         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     2  /        Instrument Handle                 3H H      status                           Sy        Service Request                    0    	            On 1 Off 0       The power supply has two modes of operation, constant current and constant voltage. This function configures the power supply to shut down if the power supply switches from constant current mode to constant voltage mode. If Service Request is set ON (1) the Protection Event Status reporting mechanism will be turned on and a GPIB Service Request will be generated upon this action.         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     6  /        Instrument Handle                 6 H      status                           Tx        Service Request                    0    	            On 1 Off 0        The power supply has two modes of operation, constant current and constant voltage. This function configures the power supply to operate in both modes. All Protection Event Status reporting mechanisms will be turned off.         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     8  2        Instrument Handle                 9 K      status                             0    	                This function configures the power supply to generate a triggered DC voltage . A software trigger must be used to initiate this sequence.

SCPI: SOURCE[]:VOLTAGE:TRIG <voltage value>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      w    Pass the DC voltage you want the power supply to generate.
Units: volts
Valid Range: dependent upon the model in use
    ;C          Instrument Handle                 ;        Status                            <m 3        Voltage                                	           0.0        This function configures the power supply to generate a triggered DC current. A software trigger must be used to initiate this sequence.

SCPI: SOURCE[]:CURRENT:TRIG <current value>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      v    Pass the DC current you want the power supply to generate.
Units: amps
Valid Range: dependent upon the model in use
    >a          Instrument Handle                 ?	        Status                            ? 3        Current                                	           0.0   2    This function configures the power supply to generate a triggered DC voltage ramp starting at the present output voltage and ending at the specified voltage in the specified time. Time is in seconds. See Send Software Trigger for more information.

SCPI: SOURCE[]:VOLTAGE:RAMP:TRIG <voltage value> <time>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     y    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     w    Pass the DC voltage you want the power supply to generate.
Units: volts
Valid Range: dependent upon the model in use
     .    Ramp time in seconds.
Range is 0.1 - 99 sec.    A          Instrument Handle                 B        Status                            C" 6        Voltage                           C 6        Time                                   	           0.0    0.0   2    This function configures the power supply to generate a triggered DC current ramp starting at the present output current and ending at the specified current in the specified time. Time is in seconds. See Send Software Trigger for more information.

SCPI: SOURCE[]:CURRENT:RAMP:TRIG <current value> <time>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     y    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     v    Pass the DC current you want the power supply to generate.
Units: amps
Valid Range: dependent upon the model in use
     .    Ramp time in seconds.
Range is 0.1 - 99 sec.    F          Instrument Handle                 F        Status                            G, ?        Current                           G >        Time                                   	           0.0    0.0        This function sets the Over Voltage Protection limit. If the output of the instrument exceeds this value the instrument will shutdown and must be Reset to continue.

SCPI: SOURCE[]:VOLTAGE:PROTECTION <ovp value>
         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          Pass the DC over voltage value you want the power supply shutdown at.
Units: volts
Valid Range: dependent upon the model in use

    I          Instrument Handle                 JX        Status                            J 3        Overvoltage Protection                 	           0.0        This function sets the soft voltage and current programming limits.

SCPI: SOURCE[]:VOLTAGE:LIMIT <voltage value>
      SOURCE[]:CURRENT:LIMIT <current value>     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
    L        Status                            ME          Instrument Handle                j        Volltage Limit                   n        Current Limit                      	               0.0    0.0        This function sets the power on output values for voltage, current, and over voltage protection.

SCPI: CALIBRATE[]:INITIAL:VOLTAGE <voltage value>
      CALIBRATE[]:INITIAL:CURRENT <current value>
      CALIBRATE[]:INITIAL:VOLTAGE:PROTECTION <ovp value>     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
    O        Status                            Pi          Instrument Handle                _        Voltage                          W        Current                                  OVP                                	               0.0    0.0    0.0       This routine configures foldback mode. The three mode are: 0 = off, 1 = Constant Volatge, 2 = Constant Current. Configuring the foldback mode for Constant Voltage or Constant Current will cause the power supply to shut down if the other mode becomes active.         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.    bi       Mode                              SJ  0        Instrument Handle                 S h      Status                             0        	               Sets the programmable time delay that is executed by the supply before reporting output protection conditions after a new output voltage or current value is specified. Range is from 0 to 32 seconds.     $    Time Delay value, 0 to 32 seconds.         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     U bi       Delay                             V$  0        Instrument Handle                 V h      Status                             0        	               This routine configures the number of voltage measurements to be average upon recept of a measure output voltage command.  Acceptable number is from one (1) to five (5) and the Default is one (1). No explicit time is used between measurements.     0    Number of voltage measurements to be averaged.         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     X bi       Average                           Y7  0        Instrument Handle                 Y h      Status                             1        	               This routine configures the number of current measurements to be average upon recept of a measure output current command.  Acceptable number is from one (1) to five (5) and the Default is one (1). No explicit time is used between measurements.     0    Number of current measurements to be averaged.         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     \ bi       Average                           \J  0        Instrument Handle                 \ h      Status                             1        	          b    This routine configures the Protection Event Status Enable Register which causes the instrument to shut down if Constant Current, Constant Voltage, Foldback Modes or other conditions are enabled. Along with this register the Service Request Enable Register must be programmed to generate GPIB Service Requests.

SCPI: STATUS[]:PROTECTION:ENABLE <value>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     _          Instrument Handle                 `: N      Status                           HO        Protection Event Enable                	           0        This routine configures the Standard Event Status Enable Register. Along with this register the Service Request Enable Register must be programmed to generate GPIB Service Requests.

SCPI: *ESE[] <value>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     bE          Instrument Handle                 b N      Status                           HO        Standard Event Enable                  	           0   n    This routine sets the Service Request Enable Register which is used to enable GPIB Service Requests when a enabled protection event or standard event has occured. This register along with the Protection Event Status Enable Register or the Standard Event Status Enable Register must be programmed to enable generation of GPIB Service Requests.

SCPI: *SRE[] <value>         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     e          Instrument Handle                 fA >      Status                           :B        Service Request Enable                 	           0    L    This function returns the programmed voltage value.

SCPI: SOURCE[]:VOLT?
     -    Returns the measured value.

Units:  volts
         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     g 3        Programmed Voltage                h   	        Instrument Handle                 h        Status                             	               	           O    This function returns the programmed current value.

SCPI: SOURCE[]:CURRENT?
     /    Returns the measured value.

Units:  amperes
         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     j< 3        Programmed Current                js  	        Instrument Handle                 k        Status                             	               	           h    This function returns the programmed overvoltage protection value.

SCPI: SOURCE[]:VOLTAGE:PROTECTION?     /    Returns the programmed value.

Units:  volts
         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     l 3        Programmed OVP                    l  	        Instrument Handle                 m        Status                             	               	           :    This function gets the output state - On (1) or Off (0).         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     o&  4        Instrument Handle                 o       Status                           _       State                                  	            	                This function recalls the soft voltage and current programming limits.

SCPI: SOURCE[]:VOLTAGE:LIMIT?
      SOURCE[]:CURRENT:LIMIT?         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     q  	        Instrument Handle                 r@       Status                           O        Voltage Limit                    Q        Current Limit                          	           	           	               This function recalls the power on output voltage, current, and ovp values.

SCPI: CALIBRATE[]:INITIAL:VOLTAGE?
      CALIBRATE[]:INITIAL:CURRENT?
      CALIBRATE[]:INITIAL:VOLTAGE:PROTECTION?         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.     t          Instrument Handle                 u0        Status                           6        Voltage                          4        Current                                  OVP                                    	           	           	           	           b    This function recalls the protection condition reporting delay .

SCPI: OUTPUT:PROTECTION:DELAY?         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      #    Protection condition delay value.    wY          Instrument Handle                 x        Status                            x 3        Delay                                  	           	               This function recalls the number of voltage reading that will be averaged upon receipt of a voltage measurent command.

SCPI: MEASURE:VOLTAGE:AVERAGE?         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      7    The number of voltage readings that will be averaged.    z	          Instrument Handle                 z        Status                            {3 3        Average                                	           	                This function recalls the number of current reading that will be averaged upon receipt of a current measurent command.

SCPI: MEASURE:CURRENT:AVERAGE?         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      7    The number of current readings that will be averaged.    |          Instrument Handle                 }u        Status                            } 3        Average                                	           	                This function sends a software trigger. The trigger types are as follows:

1 = Voltage
2 = Current
3 = Both Voltage and Current
4 = Voltage or Current Ramp

SCPI: TRIGGER[]:TYPE <value>
      TRIGGER[]:RAMP         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     y    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.      8        Instrument Handle                 q <      Status                           N>       Trigger Type                       0    	           1    f    This function clears all previously configured voltage and current triggers.

SCPI: TRIGGER[]:ABORT          The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.       '        Instrument Handle                         Status                             0    	               This function reads the status byte from the instrument and creates a string that indicates which bits are active.

SCPI: *STB[]?

     N    This control returns the error code read from the instrument's error queue.
         This control returns the error message string read from the instrument's error message queue.

Notes:

(1) The array must contain at least 256 elements ViChar[256].     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    G X         Status Byte                         n  ,    Status Message                    K (      Status                              5        Instrument Handle                  	            	            	                   This function reads the standard event status register from the instrument and creates a string that indicates which bits are active.

SCPI: *ESR[]?

     N    This control returns the error code read from the instrument's error queue.
         This control returns the error message string read from the instrument's error message queue.

Notes:

(1) The array must contain at least 256 elements ViChar[256].     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     G         Standard Event Status Register    ^  t  ,    Status Message                     >      Status                              5        Instrument Handle                  	            	            	                   This function reads the event status enable register from the instrument and creates a string that indicates which bits are active.

SCPI: *ESE[]?

     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   G         Standard Event  Enable Register   t  ,    Status Message                     >      Status                            I  5        Instrument Handle                  	            	            	                   This function reads the protection event status reister from the instrument and creates a string that indicates which bits are active.

SCPI: STATUS[]:PROTECTION:EVENT?

     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   W         Protection Event Register           ,    Status Message                    g      Status                             +        Instrument Handle                  	            	            	                   This function reads the protection event status enable register from the instrument and creates a string that indicates which bits are active.

SCPI: STATUS[]:PROTECTION:ENABLE?

     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   _         Prot. Event Enable Register         ,    Status Message                    rg      Status                             +        Instrument Handle                  	            	            	                  This function reads the protection condition status reister from the instrument and creates a string that indicates which bits are active. Use this routine to determine the operating mode (voltage or current) of the power supply.

SCPI: STATUS[]:PROTECTION:CONDITION?

     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   P         Protection Condition Register     ~  ,    Status Message                    g      Status                            ( +        Instrument Handle                  	            	            	                   This function reads the service request enable reister from the instrument and creates a string that indicates which bits are active.

SCPI:*SRE[]?

     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   L         Service Req. Enable Register      ~  ,    Status Message                    bg      Status                             +        Instrument Handle                  	            	            	                   This function resets the instrument to its Power On state and clears all error and status reporting data structures.

SCPI: *RST[]
      *CLS[]

     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     G      Status                              *        Instrument Handle                  	               V    This function clears all error and status reporting data structures.

SCPI: *CLS[]

     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     G      Status                              *        Instrument Handle                  	               l    This function reads an error code and error string from the instrument's error queue.

SCPI: SYSTEM:ERROR?     N    This control returns the error code read from the instrument's error queue.
         This control returns the error message string read from the instrument's error message queue.

Notes:

(1) The array must contain at least 256 elements ViChar[256].     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    " = D   `    Error Code                        x ?   ,    Error Message                     & ?      Status                              6        Instrument Handle                  	            	            	                   This function takes the Status Code returned by the instrument driver functions, interprets it and returns it as a user readable string.      t    This control accepts the Status Code returned from the instrument driver functions.

Default Value:
0 - VI_SUCCESS         This control returns the interpreted Status Code as a user readable message string.

Notes:

(1) The array must contain at least 256 elements ViChar[256].     (    Reports the status of this operation.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  VI_NULL     r    `    Status Code                       R  0      Message                           
      Status                            & 5        Instrument Handle                  0    	            	           VI_NULL    ~    This function returns the Manufacturer, Model, Serial Number and firmware revision numbers of the instrument.

SCPI: *IDN[]?         This control returns the Instrument Driver Software Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    J S        *IDN? Respone                            Status                            Z  1        Instrument Handle                  	            	               ^    This function returns the revision numbers of the instrument driver and instrument firmware.         This control returns the Instrument Driver Software Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].         This control returns the Instrument Firmware Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     C        Instrument Driver Revision                 Firmware Revision                 / ]      Status                              3        Instrument Handle                  	            	            	                   This function recalls the instrument's maximum voltage and current rating.

SCPI: CALIBRATE[]:MODEL:VOLTAGE?
      CALIBRATE[]:MODEL:CURRENT?         The ViSession handle that you obtain from the Init or InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.       	        Instrument Handle                         Status                           ? 
       Model Voltage                    ?        Model Current                          	           	           	               This function performs the following operations:
viClose (instrSession) and viClose (rmSession).

Notes:

(1) The instrument must be reinitialized to use it again.     z    Reports the status of this operation.

To obtain a text description of the status code call the error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     pD      Status                            8 r `        Instrument Handle                  	                       G             K.        init                                                                                                                                                            K.        GenerateDCVolt                                                                                                                                                  K.        GenerateDCCurr                                                                                                                                   j  !             .        GenerateDCVRamp                                                                                                                                  "  %             .        GenerateDCCRamp                                                                                                                                  &  (             K.        OutState                                                                                                                                         )a  +             .        MeasureDCVolt                                                                                                                                    +  -             .        MeasureDCCurr                                                                                                                                    .M  0\             K.        ModeQuery                                                                                                                                        1  3             K.        VoltMode                                                                                                                                         4  7:             K.        CurrMode                                                                                                                                         7  :             K.        NormalMode                                                                                                                                       :  <             K.        ConfigDCVolt                                                                                                                                     =  @	             K.        ConfigDCCurr                                                                                                                                     @  C             K.        ConfigDCVRamp                                                                                                                                    D  G             K.        ConfigDCCRamp                                                                                                                                    H  Ke             K.        ConfigOVP                                                                                                                                        L  M             K.        ConfigSoftLimits                                                                                                                                 N  Q             K.        ConfigPowerOn                                                                                                                                    R?  Tt             K.        ConfigFoldback                                                                                                                                   U(  WN             K.        ConfigProtDelay                                                                                                                                  X  Za             K.        ConfigVoltAve                                                                                                                                    [  ]t             K.        ConfigCurrAve                                                                                                                                    ^(  `             K.        ConfigProtEventEnable                                                                                                                            ap  co             K.        ConfigStandEventEnable                                                                                                                           d#  f             K.        ConfigSerReqEnable                                                                                                                               gw  i*             .        OutputVoltQuery                                                                                                                                  i  k             .        OutputCurrQuery                                                                                                                                  lX  n)             .        OutputOVPQuery                                                                                                                                   n  pP             K.        OutStateQuery                                                                                                                                    q  r             .        SoftLimitsQuery                                                                                                                                  s  u             .        PowerOnQuery                                                                                                                                     v  x             .        protDelayQuery                                                                                                                                   yi  {r             .        measVoltAveQuery                                                                                                                                 |-  ~6             .        measCurrAveQuery                                                                                                                                 ~               K.        SendSWTrigger                                                                                                                                      ?             K.        AbortTrigger                                                                                                                                       l             K.        StatusByteQuery                                                                                                                                  h  -             K.        StandEventQuery                                                                                                                                  )               K.        StandEventEnableQuery                                                                                                                                           K.        ProtEventQuery                                                                                                                                                  K.        ProtEventEnableQuery                                                                                                                                            K.        ProtCondQuery                                                                                                                                                   K.        ServiceReqEnableQuery                                                                                                                              ;             K.        reset                                                                                                                                              4             K.        clear                                                                                                                                              G             K.        errorQuery                                                                                                                                       C               K.        errorMessage                                                                                                                                                    K.        idQuery                                                                                                                                            P             E.        revisionQuery                                                                                                                                    L  
             .        ModelQuery                                                                                                                                       	               K.        close                                                                                                                                                                                                                               Initialize                                                                          Application Functions                                                             Generate Output                                                                      Generate DC Voltage                                                                  Generate DC Current                                                                  Generate DC Voltage Ramp                                                             Generate DC Current Ramp                                                            Output State                                                                         Output State On/Off                                                               Measure Output                                                                       Measure DC Voltage                                                                   Measure DC Current                                                                Operating Mode                                                                       Query Output Mode                                                                    Constant Voltage Mode                                                                Constant Current Mode                                                                Normal Mode                                                                         Configuration Functions                                                              Configure DC Voltage                                                                 Configure DC Current                                                                 Configure DC Voltage Ramp                                                            Configure DC Current Ramp                                                            Configure OVP                                                                        Configure Soft Limits                                                                Configure Power On                                                                   Configure Foldback                                                                   Configure Protection Delay                                                           Configure Voltage Measurement Average                                                Configure Current Measurement Average                                                Configure Protect. Event Enable                                                      Configure Standard Event Enable                                                      Configure Service Req. Enable                                                        Output Voltage Query                                                                 Output Current Query                                                                 Output OVP Query                                                                     Output State Query                                                                   Soft Limits Query                                                                    Power On Query                                                                       Protection Delay Query                                                               Voltage Measurement Average Query                                                    Current Measurement Average Query                                                   xAction/Status Functions                                                              Send Software Trigger                                                                Abort Trigger                                                                        Status Byte Query                                                                    Standard Event Query                                                                 Standard Event Enable Query                                                          Protection Event Query                                                               Protection Event Enable Query                                                        Protection Condition Query                                                           Sevice Req. Enable Query                                                            ]Utility Functions                                                                    Reset                                                                                Clear                                                                                Error Query                                                                          Error Message                                                                        Id Query                                                                             Revision Query                                                                       Model Query                                                                          Close                                                                           